<?php


/**
 * Product class.
 * 
 * @extends REST_Controller
 */
require APPPATH . '/libraries/REST_Controller.php';
use Restserver\Libraries\REST_Controller;

class Transaksi_minum extends REST_Controller {

      /**
     * CONSTRUCTOR | LOAD MODEL
     *
     * @return Response
    */
      public function __construct() {
       parent::__construct();
       $this->load->library('Authorization_Token');
       $this->load->model('Minum_model');
     }

    /**
     * SHOW | GET method.
     *
     * @return Response
    */
    public function index_get($id_cust = 0, $id_club = 0)
    {
      $final = array();
      $headers = $this->input->request_headers(); 
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status'])
        {
                // ------- Main Logic part -------
                // set validation rules
          $input_validation['id_cust'] = $id_cust;
          $input_validation['id_club'] = $id_club;
          $this->form_validation->set_data($input_validation);
          $this->form_validation->set_rules('id_cust', 'id_cust', 'required|alpha_numeric');
          $this->form_validation->set_rules('id_club', 'id_club', 'required|alpha_numeric');
          if ($this->form_validation->run() == true) {
            $page = $this->input->get('page', TRUE);
            $limit = $this->input->get('limit', TRUE);
            $id_vip = $this->input->get('id_vip', TRUE);
            if(empty($page)) $page=1;
            if(empty($limit)) $limit=10;
            if(empty($limit)) {
              $data = $this->Minum_model->show($id_cust,$id_club,$page,$limit);
            } else {
              $data = $this->Minum_model->show($id_cust,$id_club,$page,$limit,$id_vip);
            }
            $final['status'] = true;
            $final['message'] = 'Data confirmed';
            $final["data"] = $data;
          } else {
                    // validation not ok, send validation errors to the view
            $final['status'] = false;
            $final['message'] = 'Validation rules violated';
          }
                // ------------- End -------------
        } 
        else {
          $final = $decodedToken;
        }
      } else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                        
      }
      $this->response($final, REST_Controller::HTTP_OK);          
    }



  }