<?php


/**
 * Product class.
 * 
 * @extends REST_Controller
 */
require APPPATH . '/libraries/REST_Controller.php';
use Restserver\Libraries\REST_Controller;

class Club extends REST_Controller {

	  /**
     * CONSTRUCTOR | LOAD MODEL
     *
     * @return Response
    */
    public function __construct() {
       parent::__construct();
       $this->load->library('Authorization_Token');	
       $this->load->model('Club_model');
   }

    /**
     * SHOW | GET method.
     *
     * @return Response
    */
    public function index_get($id = 0)
    {
        $final = array();
        $headers = $this->input->request_headers(); 
        if (isset($headers['Authorization'])) {
            $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
            if ($decodedToken['status'])
            {
                // ------- Main Logic part -------
                // set validation rules
                $input_validation['id'] = $id;
                $this->form_validation->set_data($input_validation);
                $this->form_validation->set_rules('id', 'id', 'required|alpha_numeric');
                if ($this->form_validation->run() == true) {
                    $data = $this->Club_model->show($id);
                    if($data->aktif==1) {
                        $final['status'] = true;
                        $final['message'] = 'Data confirmed';
                        $final["data"] = $data;
                    }else {
                        $final['status'] = false;
                        $final['message'] = 'Club: '.$data->nama_club.' is no longer active';
                        $final['data'] = null;
                    }
                } else {
                    // validation not ok, send validation errors to the view
                    $final['status'] = false;
                    $final['message'] = 'Validation rules violated';
                }
                // ------------- End -------------
            } 
            else {
                $final = $decodedToken;
            }
        } else {
            $final['status'] = false;
            $final['message'] = 'Authentication failed';                        
        }

        $this->response($final, REST_Controller::HTTP_OK);          
    }



}