<?php


/**
 * Product class.
 * 
 * @extends REST_Controller
 */
require APPPATH . '/libraries/REST_Controller.php';
use Restserver\Libraries\REST_Controller;

class We_roadshow extends REST_Controller {

      /**
     * CONSTRUCTOR | LOAD MODEL
     *
     * @return Response
    */
      public function __construct() {
       parent::__construct();
       $this->load->library('Authorization_Token');
       $this->load->model('We_roadshow_model');
     }

    /**
     * SHOW | GET method.
     *
     * @return Response
    */
    public function index_get($id_user = 0, $id_club = 0)
    {
      $final = array();
      $headers = $this->input->request_headers(); 
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status'])
        {
                // ------- Main Logic part -------
                // set validation rules
          $input_validation['id_user'] = $id_user;
          $input_validation['id_club'] = $id_club;
          $this->form_validation->set_data($input_validation);
          $this->form_validation->set_rules('id_user', 'id_user', 'required|alpha_numeric');
          $this->form_validation->set_rules('id_club', 'id_club', 'required|alpha_numeric');
          if ($this->form_validation->run() == true) {
            $page = $this->input->get('page', TRUE);
            $limit = $this->input->get('limit', TRUE);
            if(empty($page)) $page=1;
            if(empty($limit)) $limit=10;
            $data = $this->We_roadshow_model->show($id_user,$id_club,$page,$limit);
            $final['status'] = true;
            $final['message'] = 'Data confirmed';
            $final["data"] = $data;
          } else {
                    // validation not ok, send validation errors to the view
            $final['status'] = false;
            $final['message'] = 'Validation rules violated';
          }
                // ------------- End -------------
        } 
        else {
          $final = $decodedToken;
        }
      } else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                        
      }
      $this->response($final, REST_Controller::HTTP_OK);          
    }


    /**
     * SHOW | POST method.
     *
     * @return Response
    */
    public function index_post()
    {
      $headers = $this->input->request_headers(); 
      $final = array();
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status']) {

                // ------- Main Logic part -------
          $input_data = json_decode($this->input->raw_input_stream, true);
          // var_dump($input_data) ;
          $response = $this->We_roadshow_model->create($input_data);
          if($response>0) {
            $final['status'] = true;
            $final['message'] = 'We_roadshow updated successfully.'; 
          } else {
            $final['status'] = false;
            $final['message'] = 'Not updated';                
          }
                // ------------- End -------------
        } else {
          $final = $decodedToken;
        }
      }
      else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                
      }
      $this->response($final, REST_Controller::HTTP_OK);      
    }

  }