<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class We_roadshow_model extends CI_Model {

    /**
     * CONSTRUCTOR | LOAD DB
    */
    public function __construct() {
     parent::__construct();
     $this->load->database();
 }

    /**
     * SHOW | GET method.
     *
     * @return Response
     *  $tgl :
     *   1 : Hari ini (tanggal)
     *   2 : Kemarin (tanggal)
     *   3 : Bulan ini (thn+bulan)
     *   4 : Bulan lalu (thn+bulan)
    */
    public function show($id_user = 0,$id_club = 0, $tgl = 1, $page = 0, $limit = 10)
    {
        if(empty($id_user)) $id_user=0;
        if(empty($id_club)) $id_club=0;
        if(empty($page)) $page=0;
        if(empty($limit)) $limit=10;

        $offset = ($page-1)*$limit;
        $filter_limit = " limit ".$offset.",".$limit;

        switch ($tgl) {
          case 4:  //bulan lalu
            $filter_tgl = " and DATE_FORMAT(create_tgl,'%Y%m')=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 1 MONTH),'%Y%m')";
            break;
          case 3:  //bulan ini
            $filter_tgl = " and DATE_FORMAT(create_tgl,'%Y%m')=DATE_FORMAT(curdate(),'%Y%m')";
            break;
          case 2: //kemarin
            $filter_tgl = " and DATE(create_tgl)=SUBDATE(CURDATE(),1)";
            break;
          default: //hari ini
            $filter_tgl = " and DATE(create_tgl)=CURDATE()";
        }

        $sql = "SELECT * from we_roadshow where ".
        " id_user='".$id_user."' ".
        " and id_club='".$id_club."' ".$filter_tgl." order by id DESC ".$filter_limit;      
        $query = $this->db->query($sql)->result();
        return $query;
    }



    /**
     * create_user function.
     * 
     * @access public
     * @param mixed $username
     * @param mixed $email
     * @param mixed $password
     * @return bool true on success, false on failure
     */
    public function create($input_data) {

        date_default_timezone_set("Asia/Bangkok");
        $tgl_now = date("Y-m-d H:i:s");

        if(!$input_data["followup_flag"]){
            $fu_flag = "STOP";
            $fu_schedule = "0000-00-00";
        }else{
            $fu_flag = "YA";
            $sql = "SELECT DATE_ADD(CURDATE(), INTERVAL ".$input_data["followup_schedule"]." DAY) as fu_schedule";
            $query = $this->db->query($sql)->result();
            $fu_schedule = $query[0]->fu_schedule;
        }

        $data = array(
            'id_club' => $input_data["id_club"],
            'id_user' => $input_data["id_user"],
            'nama' => $input_data["nama"],
            'hp' => $input_data["hp"],
            'usia' => $input_data["usia"],
            'jenis_kelamin' => $input_data["jenis_kelamin"],
            'tinggi_badan' => $input_data["tinggi_badan"],
            'berat_badan' => $input_data["berat_badan"],
            'lemak_tubuh' => $input_data["lemak_tubuh"],
            'kadar_air' => $input_data["kadar_air"],
            'massa_otot' => $input_data["massa_otot"],
            'rating_fisik' => $input_data["rating_fisik"],
            'kebutuhan_kalori' => $input_data["kebutuhan_kalori"],
            'usia_sel' => $input_data["usia_sel"],
            'massa_tulang' => $input_data["massa_tulang"],
            'lemak_perut' => $input_data["lemak_perut"],
            'bmi' => $input_data["bmi"],
            'protein' => $input_data["protein"],
            'create_tgl' => $tgl_now,
            'latitude' => $input_data["latitude"],
            'longitude' => $input_data["longitude"],
            'rating' => $input_data["rating"],
            'keterangan' => $input_data["keterangan"],
            'fu_flag' => $fu_flag,
            'fu_schedule' => $fu_schedule,
        );

        // var_dump($data) ;
        
        $this->db->insert('we_roadshow', $data);
        $sql2 = "update we_roadshow set qrcode=md5(id) where id=".$this->db->insert_id();
        $this->db->query($sql2);

        return $this->db->insert_id(); 
        
    }



    /**
     * dashboardHasil | GET method.
     *
     * @return Response
     *  $tgl :
     *   1 : Hari ini (tanggal)
     *   2 : Kemarin (tanggal)
     *   3 : Bulan ini (thn+bulan)
     *   4 : Bulan lalu (thn+bulan)
    */
    public function dashBoardHasil($id_user = 0,$id_club = 0, $tgl = 1 )
    {
        if(empty($id_user)) $id_user=0;
        if(empty($id_club)) $id_club=0;
        if(empty($tgl)) $tgl=1;

        $sql = "SELECT * FROM user WHERE ".
        " LOWER(is_aktif)='y' and ".
        " id_club='".$id_club."' order by id ASC ";      
        $query = $this->db->query($sql);

        switch ($tgl) {
          case 4:  //bulan lalu
            $filter_tgl = " and DATE_FORMAT(create_tgl,'%Y%m')=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 1 MONTH),'%Y%m')";
            break;
          case 3:  //bulan ini
            $filter_tgl = " and DATE_FORMAT(create_tgl,'%Y%m')=DATE_FORMAT(curdate(),'%Y%m')";
            break;
          case 2: //kemarin
            $filter_tgl = " and DATE(create_tgl)=SUBDATE(CURDATE(),1)";
            break;
          default: //hari ini
            $filter_tgl = " and DATE(create_tgl)=CURDATE()";
        }

        foreach ($query->result() as $row) {

            $sql2 = "SELECT count(*) as jml FROM `we_roadshow` ".
                    " where id_user='".$row->id."' ".$filter_tgl;

            // echo $sql2;

            $query2 = $this->db->query($sql2)->row();
            
            $final['status'] = true;
            $final['message'] = 'Data confirmed';
            $data [] = array(
                'id' => $row->id,
                'nama' => $row->nama,
                'images' => $row->images,
                'user_level' => $row->user_level,
                'jml' => $query2->jml
            );
        }
        return $data;
    }



    /**
     * SHOWFOLLOWUP | GET method.
     *
     * @return Response
    */
    public function showFollowUp($id_we, $page = 0, $limit = 10)
    {
        if(empty($id_we)) $id_we=0;
        if(empty($page)) $page=0;
        if(empty($limit)) $limit=10;

        $offset = ($page-1)*$limit;
        $filter_limit = " limit ".$offset.",".$limit;

        $sql = "SELECT * from we_roadshow_fu where ".
        " id_we='".$id_we."' ".
        " order by id DESC ".$filter_limit;      
        $query = $this->db->query($sql)->result();
        return $query;
    }


    /**
     * create_user function.
     * 
     * @access public
     * @param mixed $username
     * @param mixed $email
     * @param mixed $password
     * @return bool true on success, false on failure
     */
    public function addFollowUp($input_data) {

        date_default_timezone_set("Asia/Bangkok");
        $tgl_now = date("Y-m-d H:i:s");

        if(!$input_data["followup_flag"]){
            $fu_flag = "STOP";
            $fu_schedule = "0000-00-00";
        }else{
            $fu_flag = "YA";
            if($input_data["followup_schedule"]=="30") {
                $sql = "SELECT DATE_ADD(CURDATE(), INTERVAL 1 MONTH) as fu_schedule";
            } else {
                $sql = "SELECT DATE_ADD(CURDATE(), INTERVAL ".$input_data["followup_schedule"]." DAY) as fu_schedule";
            }
            $query = $this->db->query($sql)->result();
            $fu_schedule = $query[0]->fu_schedule;
        }
        $sql2 = "update we_roadshow set fu_flag='".$fu_flag."', fu_schedule='".$fu_schedule."' where id=".$input_data["id_we"];
        $this->db->query($sql2);

        $data = array(
            'id_we' => $input_data["id_we"],
            'id_user' => $input_data["id_user"],
            'nama_user' => $input_data["nama_user"],
            'keterangan' => $input_data["keterangan"],
            'tgl' => $tgl_now,
        );

        // var_dump($data) ;
        
        $this->db->insert('we_roadshow_fu', $data);

        return $this->db->insert_id(); 
        
    }


}
