<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");  
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS'); 
header('Access-Control-Max-Age: 1000');  
header('Access-Control-Allow-Headers: *');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token , Authorization');



defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = '';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

/* API */
// $route['product'] = 'api/Product';
// $route['product/(:any)'] = 'api/Product/$1';
// $route['product/(:num)']['PUT'] = 'api/Product/$1';
// $route['product/(:num)']['DELETE'] = 'api/Product/$1';
// $route['register'] = 'api/User/register';

$route['login'] = 'api/User/login';
$route['loginBiometric'] = 'api/User/loginBiometric';
$route['isPhoneExist/(:num)'] = 'api/User/isPhoneExist/$1';
$route['user/(:num)'] = 'api/User/$1';
$route['logout'] = 'api/User/logout';
// $route['loginReload'] = 'api/User/loginReload';
$route['updateProfile/(:num)']['PUT'] = 'api/User/updateProfile/$1';
$route['changePassword/(:num)']['PUT'] = 'api/User/changePassword/$1';
$route['changePassword/(:num)']['OPTIONS'] = 'api/User/cors';
$route['insertLog']['POST'] = 'api/User/insertLog';
$route['logout'] = 'api/User/logout';
$route['reGenToken'] = 'api/Token/reGenToken';
$route['club'] = 'api/Club';
$route['club/(:num)'] = 'api/Club/$1';
$route['WeRoadShow/(:num)/(:num)'] = 'api/We_roadshow/$1/$2';
$route['WeRoadShow'] = 'api/We_roadshow';


//$route['WeCustomer/(:num)/(:num)'] = 'api/We_customer/$1/$2';
//$route['WeCustomer'] = 'api/We_customer';
$route['Setting'] = 'api/Setting';




/*

$route['default_controller'] = '';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

// $route['product'] = 'api/Product';
// $route['product/(:any)'] = 'api/Product/$1';
// $route['product/(:num)']['PUT'] = 'api/Product/$1';
// $route['product/(:num)']['DELETE'] = 'api/Product/$1';
// $route['register'] = 'api/User/register';
$route['login'] = 'api/User/login';
$route['loginBiometric'] = 'api/User/loginBiometric';
$route['isPhoneExist'] = 'api/User/isPhoneExist';
$route['logout'] = 'api/User/logout';
$route['user/(:num)'] = 'api/User/$1';
// $route['loginReload'] = 'api/User/loginReload';
$route['updateProfile/(:num)']['PUT'] = 'api/User/updateProfile/$1';
$route['changePassword/(:num)']['PUT'] = 'api/User/changePassword/$1';
$route['insertLog']['POST'] = 'api/User/insertLog';
$route['logout'] = 'api/User/logout';
$route['reGenToken'] = 'api/Token/reGenToken';
$route['club'] = 'api/Club';
$route['club/(:num)'] = 'api/Club/$1';
$route['transaksiEpay/(:num)/(:num)'] = 'api/Transaksi_epay/$1/$2';
$route['transaksiProduk/(:num)/(:num)'] = 'api/Transaksi_produk/$1/$2';
$route['transaksiMinum/(:num)/(:num)'] = 'api/Transaksi_minum/$1/$2';
$route['transaksiPaket/(:num)/(:num)'] = 'api/Transaksi_paket/$1/$2';
$route['WeCustomer/(:num)/(:num)'] = 'api/We_customer/$1/$2';
$route['WeCustomer'] = 'api/We_customer';
$route['Setting'] = 'api/Setting';

*/
